_G.core = {}
dofile("builtin/common/math.lua")

describe("math", function()
	it("round()", function()
		assert.equal(0, math.round(0))
		assert.equal(10, math.round(10.3))
		assert.equal(11, math.round(10.5))
		assert.equal(11, math.round(10.7))
		assert.equal(-10, math.round(-10.3))
		assert.equal(-11, math.round(-10.5))
		assert.equal(-11, math.round(-10.7))
		assert.equal(0, math.round(0.49999999999999994))
		assert.equal(0, math.round(-0.49999999999999994))
	end)
	it("isfinite()", function()
		assert.equal(true, math.isfinite(0.0))
		assert.equal(true, math.isfinite(2^1023)) -- assuming numbers are 64-bit floats
		assert.equal(false, math.isfinite(0/0))
		assert.equal(false, math.isfinite(math.huge))
		assert.equal(false, math.isfinite(-math.huge))
		assert.has.errors(function() math.isfinite("not a number") end)
	end)
end)
